function [ dqByDS0 ] = pricingKernelDerivative( S, T, S0, r, sigma )
%PRICINGKERNELDERIVATIVE Differentiate the pricing kernel with respect
%                        to S0

term1 = (-2*r + sigma^2)*T + 2*log( S/S0);
term2 = 8*sigma^2*T;
term3 = 2*sqrt(2*pi) * S*S0*sigma^3*T^(3/2);
dqByDS0 = exp( -term1^2/term2 )*term1/term3;

end

