function p=priceDerivativeByIntegration( payoffFunction, T, S0, r, sigma, nSteps )
%PRICEDERIVATIVEBYINTEGRATION Price a derivative by integration
% given its payoff function. The payoff function should take the final
% stock price and compute the payoff
function ret=integrand( S )
   ret = payoffFunction( S ) .*...
           pricingKernel( S, T, S0, r, sigma );
end
p = exp(-r*T) ...
    * integrateToInfinity( @integrand, 0, nSteps);
end

