function [ price ] = priceCallInTwoPieces( integrateFunction, ...
                                            K, T, S0, r, sigma, nSteps  )
%PRICEBYINTEGRATIONUSINGQ Price by integration but using
%    the function Q to convert the infinite integral to a finite
%    one

% Use the forumlae to define QInv
function S = QInv(R)
    S = S0 * exp( (r-0.5*sigma^2)*T + sigma*sqrt(T)*norminv(R));
end    

function f = integrand(R) 
    f = callPayoff( K, QInv(R));
end 

% We need to choose a point strikeR at which to break the integration into
% pieces such that Q(strikeR)=K

d1 = (log(S0/K) + (r+0.5*sigma*sigma)*T)/(sigma*sqrt(T));
strikeR = normcdf(-d1);

A = exp(-r*T)*integrateFunction( @integrand, 0, strikeR, nSteps );
B = exp(-r*T)*integrateFunction( @integrand, strikeR, 1, nSteps );

price = A+B;

end
