function [ price ] = priceByIntegrationUsingQ( integrateFunction, ...
                                               payoffFunction, T, S0, r, sigma, nSteps  )
%PRICEBYINTEGRATIONUSINGQ Price by integration but using
%    the function Q to convert the infinite integral to a finite
%    one

% Use the forumlae to define QInv
function S = QInv(R)
    S = S0 * exp( (r-0.5*sigma^2)*T + sigma*sqrt(T)*norminv(R));
end    

function f = integrand(R) 
    f = payoffFunction( QInv(R));
end 

price = exp(-r*T)*integrateFunction( @integrand, 0, 1, nSteps );


end

