function plotPricingErrors()
% Plots the error of computing the price using the priceByIntegrationUsingQ
% function

K = 105;
r = log(1.05);
S0 = 100;
sigma = 0.1;
T = 0.25;

function p = callPayoff( S )
    p = max( S-K, 0);
end

answer = blackScholesCallPrice( K,T, S0,r,sigma);

points=1:18;
NValues = 2.^points + 1;


errorR = zeros( 1, length(NValues));
errorM = zeros( 1, length(NValues));
errorT = zeros( 1, length(NValues));
for i=1:length(NValues)
    N = NValues(i);
    fprintf('Running calculation with %d points\n', N);
    rectanglePrice = priceByIntegrationUsingQ(@integrateByRectangleRule,@callPayoff,T,S0,r,sigma,N);
    monteCarloPrice = priceByIntegrationUsingQ(@integrateByMonteCarlo,@callPayoff,T,S0,r,sigma,N);
    twoPiecePrice = priceCallInTwoPieces(@integrateByRectangleRule,K,T,S0,r,sigma,N);
    errorR(i) = abs(rectanglePrice - answer);
    errorM(i) = abs(monteCarloPrice - answer);
    errorT(i) = abs(twoPiecePrice - answer);
end    

figure();
loglog( NValues, errorR, NValues, errorM, NValues, errorT );
title('Errors in numerical pricing');
xlabel('Number of points');
ylabel('Error');
legend('Rectangle rule', 'Monte Carlo', 'Two pieces' );

end

