function plotErrors()
% Plots the error of computing integral of sin from 0 to 1
points=1:18;
NValues = 2.^points + 1; % Exercise: explain this line
answer = -cos(2)+cos(0);

errorR = zeros( 1, length(NValues));
errorT = zeros( 1, length(NValues));
errorS = zeros( 1, length(NValues));
errorM = zeros( 1, length(NValues));
for i=1:length(NValues)
    N = NValues(i);
    fprintf('Running calculation with %d points\n', N);
    errorR(i) = abs(integrateByRectangleRule(@sin,0,2,N) - answer);
    errorT(i) = abs(integrateByTrapeziumRule(@sin,0,2,N) - answer);
    errorS(i) = abs(integrateBySimpsonsRule(@sin,0,2,N) - answer);
    errorM(i) = abs(integrateByMonteCarlo(@sin,0,2,N) - answer);
end    

figure();
loglog( NValues, errorR, NValues, errorT, NValues, errorS, NValues, errorM );
title('Errors in numerical integration');
xlabel('Number of points');
ylabel('Error');
legend('Rectangle rule', 'Trapezium rule', 'Simpsons rule', 'Monte Carlo' );

end

