function plotCallPricingErrors()
points=1:18;
NValues = 2.^points + 1;

K = 105;
T = 0.25;
S = 100;
r = 0.05;
sigma = 0.1;

answer = blackScholesCallPrice(K,T,S,r,sigma);

errorR = zeros( 1, length(NValues));
errorT = zeros( 1, length(NValues));
errorS = zeros( 1, length(NValues));
errorM = zeros( 1, length(NValues));
for i=1:length(NValues)
    N = NValues(i);
    fprintf('Running calculation with %d points\n', N);
    errorR(i) = abs(priceCallByIntegrationConfigurable(K,T,S,r,sigma,N,@integrateByRectangleRule) - answer);
    errorT(i) = abs(priceCallByIntegrationConfigurable(K,T,S,r,sigma,N,@integrateByTrapeziumRule) - answer);
    errorS(i) = abs(priceCallByIntegrationConfigurable(K,T,S,r,sigma,N,@integrateBySimpsonsRule) - answer);
    errorM(i) = abs(priceCallByIntegrationConfigurable(K,T,S,r,sigma,N,@integrateByMonteCarlo) - answer);
end    

figure();
loglog( NValues, errorR, NValues, errorT, NValues, errorS, NValues, errorM );
title('Errors in numerical integration of call price');
xlabel('Number of points');
ylabel('Error');
legend('Rectangle rule', 'Trapezium rule', 'Simpsons rule', 'Monte Carlo' );

end

