function ret = integrateToInfinity( f, x, N, integrationRule)
% Performs a substitution to change
% the infinite integral to a finite integral.
if nargin<4
   integrationRule=@integrateByRectangleRule;
end

function r = transformedFunction( s )
    r = s^(-2) * f( x - 1 + 1/s );
    if (isnan(r)) 
        r = 0.0;
    end
end

ret=integrationRule( @transformedFunction, 0, 1, N );
end

