function p=computeDeltaByIntegration( payoffFunction, T, S0, r, sigma, nSteps )
%PRICEDERIVATIVEBYINTEGRATION Compute the delta of a derivative by
%integrating the derivative of the pricing kernel
function ret=integrand( S )
   ret = payoffFunction( S ) .*...
           pricingKernelDerivative( S, T, S0, r, sigma );
end
p = exp(-r*T) ...
    * integrateToInfinity( @integrand, 0, nSteps);
end
