function testIntegrateRichardson()
% Confirm that using richardson extrapolation
% improves our integation estimates

valueR = integrateRichardson(@sin,1,2,5);
valueT = integrateTrapezium(@sin,1,2,10);
trueValue = -cos(2)+cos(1);
assert( abs(valueR-trueValue)<abs(valueT-trueValue));

fprintf('True value %d\n',trueValue);
fprintf('Trapezium rule estimate %d\n',valueT);
fprintf('With Richardson extrapolation %d\n',valueR);
fprintf('\n');

end

