function testComputeExpectedUtility()
%TESTCOMPUTEEXPECTEDUTILITY Test the computations for exercise 1
mu = 0.08;
sigma = 0.2;
T = 1;
P = 1;

% If we choose to invest entirely in stock then our expected utility
% is simply the expected log of the stock price. We can right this down.
expectedU = (mu - 0.5*sigma^2)*T + log(P);
numericU = computeExpectedUtility(1,10000,'rectangle',0,0);
assertApproxEqual( expectedU,numericU,0.01 );
numericU = computeExpectedUtility(1,10000,'sobol',0,0);
assertApproxEqual( expectedU,numericU,0.01 );
numericU = computeExpectedUtility(1,10000,'halton',0,0);
assertApproxEqual( expectedU,numericU,0.01 );
numericU = computeExpectedUtility(1,10000,'random',0,0);
assertApproxEqual( expectedU,numericU,0.01 );

% Antithetic sampling will give perfect results in this very special case
% this is because our expected utility is the log stock price and if
% we use antithetic sampling, we'll estimate this perfectly
numericU = computeExpectedUtility(1,2,'random',1,0);
assertApproxEqual( expectedU,numericU,0.0000001 );
numericU = computeExpectedUtilityByIntegration(1);
assertApproxEqual( expectedU,numericU,0.0000001 );

proportionStock = 0.5;
accurateValue = computeExpectedUtilityByIntegration(proportionStock);
maxN = 20;
nTries = 10;
nStepsVec = zeros(maxN,1);
rectangleError = zeros(maxN,1);
sobolError = zeros(maxN,1);
haltonError = zeros(maxN,1);
randomError = zeros(maxN,nTries);
randomErrorAntithetic = zeros(maxN,nTries);
randomErrorControlVariate = zeros(maxN,nTries);
randomErrorBoth = zeros(maxN,nTries);
for n=1:maxN
    nSteps = 2^n;
    nStepsVec(n)= nSteps;
    numericU = computeExpectedUtility(proportionStock,nSteps,'rectangle',0,0);    
    rectangleError(n) = abs(numericU-accurateValue);
    numericU = computeExpectedUtility(proportionStock,nSteps,'sobol',0,0);    
    sobolError(n) = abs(numericU-accurateValue);
    numericU = computeExpectedUtility(proportionStock,nSteps,'halton',0,0);    
    haltonError(n) = abs(numericU-accurateValue);
    for inner=1:nTries
        randomError(n,inner)=abs(computeExpectedUtility(proportionStock,nSteps,'random',0,0)-accurateValue);    
        randomErrorAntithetic(n,inner)=abs(computeExpectedUtility(proportionStock,floor(nSteps/2),'random',1,0)-accurateValue);    
        randomErrorControlVariate(n,inner)=abs(computeExpectedUtility(proportionStock,nSteps,'random',0,1)-accurateValue);    
        randomErrorBoth(n,inner)=abs(computeExpectedUtility(proportionStock,floor(nSteps/2),'random',1,1)-accurateValue);    
    end
end

loglog( nStepsVec, rectangleError,...
        nStepsVec, sobolError,...
        nStepsVec, haltonError,...
        nStepsVec, mean(randomError,2),...
        nStepsVec, mean(randomErrorAntithetic,2),...
        nStepsVec, mean(randomErrorControlVariate,2),...
        nStepsVec, mean(randomErrorBoth,2));
legend('Rectangle rule', 'Sobol', 'Halton', 'Monte Carlo', 'Antithetic Sampling', 'Control Variate', 'Both');    

end

