function testCallImportance()
%TESTCALLIMPORTANCE Test pricing a call option using importance sampling
rng('Default');
S0 = 100;
K = 200;
sigma = 0.2;
r = 0.14;
T = 1;

truePrice = blackScholesCallPrice(K,T,S0,r,sigma);
[monteCarloPrice, e1] = callImportance(K,T,S0,r,sigma, 1000);
assertApproxEqual( truePrice, monteCarloPrice, 0.002);

[naiveEstimate,e2] = callMonteCarlo(K,T,S0,r,sigma, 1000);
fprintf('Importance sampling results:\n');
fprintf('True price %d\n',truePrice);
fprintf('Naive monte carlo %d\n',naiveEstimate);
fprintf('Error estimate for naive %d\n',e2);
fprintf('Importance sampling %d\n',monteCarloPrice);
fprintf('Error estimate for imortance sampling %d\n',e1);
fprintf('\n');


end

