function testCallControlVariate()
%TESTCALLIMPORTANCE Test pricing a call option using the stock
% price as a control variate
rng('Default');
S0 = 100;
K = 100;
sigma = 0.2;
r = 0.14;
T = 1;

truePrice = blackScholesCallPrice(K,T,S0,r,sigma);
[monteCarloPrice, e1Biased, c] = callControlVariate(K,T,S0,r,sigma, 1000);
[~, e1] = callControlVariate(K,T,S0,r,sigma, 1000, c);
assertApproxEqual( truePrice, monteCarloPrice, 0.05);

[naiveEstimate,e2] = callMonteCarlo(K,T,S0,r,sigma, 1000);
fprintf('Control variate results:\n');
fprintf('True price %d\n',truePrice);
fprintf('Naive monte carlo %d\n',naiveEstimate);
fprintf('Error estimate for naive %d\n',e2);
fprintf('Control variate %d\n',monteCarloPrice);
fprintf('Error estimate for control variate %d\n',e1);
fprintf('(Possibly biased error estimate for control variate %d\n)',e1Biased);
fprintf('\n');


end



