function testCallAntithetic()
%TESTCALLIMPORTANCE Test pricing a call option using antithetic sampling
%rng('Default');
S0 = 100;
K = 80;
sigma = 0.2;
r = 0.14;
T = 1;

truePrice = blackScholesCallPrice(K,T,S0,r,sigma);
[monteCarloPrice, e1] = callAntithetic(K,T,S0,r,sigma, 10000);
assertApproxEqual( truePrice, monteCarloPrice, 0.1);

[naiveEstimate,e2] = callMonteCarlo(K,T,S0,r,sigma, 10000);
fprintf('Importance sampling results:\n');
fprintf('True price %d\n',truePrice);
fprintf('Naive monte carlo %d\n',naiveEstimate);
fprintf('Error estimate for naive %d\n',e2);
fprintf('Antithetic sampling %d\n',monteCarloPrice);
fprintf('Error estimate for antithetic sampling %d\n',e1);
fprintf('\n');


end