% Perform intergration by the trapezium rule then apply richardson
% extrapolation to obtain estimates with improved convergence
function richardsonEstimate = integrateRichardson( f, a, b, N )
h1 = (b-a)/N;
h2 = (b-a)/(2*N);
estimate1 = integrateTrapezium( f,a,b,N);
estimate2 = integrateTrapezium( f,a,b,2*N);
k = h2/h1;
n = 2;
richardsonEstimate = (k^n*estimate1 - estimate2)/(k^n-1);

end