function differentiateRichardsonPlot()
%TESTDIFFERENTIATERICHARDSON Summary of this function goes here
%   Detailed explanation goes here
f = @sin;
x = 0.5;

epsilonVals = 2.^(0:-1:-16);
d1Error = zeros(length(epsilonVals),1);
d2Error = zeros(length(epsilonVals),1);
for i=1:length(epsilonVals)
    epsilon = epsilonVals(i);
    d1 = differentiateNumerically(f,x,epsilon);
    d2 = differentiateRichardson(f,x,epsilon);
    dActual = cos(0.5);
    d1Error(i) = abs(d1-dActual);
    d2Error(i) = abs(d2-dActual);
end
loglog( epsilonVals, d1Error, epsilonVals, d2Error );    
xlabel('epsilon');
ylabel('error');
legend('Standard formula', 'Richardson');
end

