function [ expectedUtility ] = computeExpectedUtilityByIntegration( stockWeighting )
    % Complete exercise 1 using the integral function
    % In this 1-d case, there is no point using rectangle rule/sobol sequences
    % etc, the built in function integral is superior
    sigma = 0.2;
    mu = 0.08;
    r  = 0.05;
    T = 1;
    S0 = 1;
    P = 1;

    mean = log(S0) + (mu-sigma^2/2)*T;
    sd = sqrt(T)*sigma;
    
    function ret = integrand(s)
        payoff = stockWeighting * P/S0 * exp(s) ...
             + (1-stockWeighting)*P*exp(r*T);
        u = log( payoff);
        u(~isfinite(u))=0;
        ret = u .* normpdf(s,mean,sd);
    end
    expectedUtility = integral(@integrand,-Inf,Inf);
end