function [ expectedUtility ] = computeExpectedUtility( stockWeighting, ...
                                                   nPoints,...
                                                   seq, ...
                                                   antithetic, ...
                                                   controlVariate )
%COMPUTEEXPECTEDUTILITY  answer exercise 1
%  stockWeighting indicates the amount of stock to hold
%  nPoints  is the number of points to generate
%  seq  defines the sequence of integration points to use
%  antithetic indicates whether to use antithetic sampling
%  controlVariate indicates whether to use a control variate

% Parameters from the question
sigma = 0.2;
mu = 0.08;
r  = 0.05;
T = 1;
S0 = 1;
P = 1;

% Choose the uniformly distributed sample points
if strcmp(seq,'rectangle')
    h = 1/(nPoints+1);
    points = ((h/2):h:(1-h/2))';
elseif strcmp(seq,'sobol')
    s = sobolset(1, 'Skip',2 );
    points = net( s, nPoints);
elseif strcmp(seq,'halton')
    h = haltonset(1, 'Skip', 2);
    points = net(h , nPoints);
elseif strcmp(seq,'random')
    points = rand( nPoints, 1);
else
    error('Invalid choice for seq parameter');
end
    
if antithetic==1
    points = vertcat( points , (1-points) );
end

% Compute the final stock price for the sample
dw = sqrt(T)*norminv( points , 0, 1);
ds = (mu-sigma^2/2)*T + sigma*dw;
logS = log(S0) + ds;
S = exp(logS);

% Compute the final payoff
payoff = stockWeighting*(P/S0)*S + exp(r*T)*(1-stockWeighting)*P;
utility = log( payoff );

% Use the control variate method using the fact that we know
% the expected stock price analytically. Note that we're using the P
% measure so the expected stock price incorporates mu.
m = utility;
t = S;
tau = exp(mu*T)*S0;
covMatrix = cov(m,t);
c = -covMatrix(1,2)/covMatrix(2,2);
% If we're not using the control variate method just set c to zero
% in the control variate formulae
if ~controlVariate
    c = 0;
end
mStar = m + c*(t-tau);

% Compute the final result
expectedUtility = mean( mStar );

end

