function [ area, errorEstimate ] = computeCircleAreaAntithetic( N, antithetic )
%COMPUTEAREAANTITHETIC Compute the area of the unit circle using
% antithetic sampling

x = 2*rand(N,1)-1;
y = 2*rand(N,1)-1;

if (antithetic) 
    x = [x ; -x];
    y = [y ; -y];
end    

hitTest = x.^2 + y.^2 <= 1;
area = 4*mean(hitTest);
errorEstimate = 4*std(hitTest)/sqrt(N);

end

