% Price a call option by importance sampling
% (Obviously this is somewhat unrealistic since we can already
% price call options anlaytically, but importance sampling can
% be applied to more interesting options)
function [price,errorEstimate] = callMonteCarlo( K,T, ...
                         S0,r,sigma, ...
                         nPaths )

logS0 = log(S0);
epsilon = randn( nPaths,1 );
logST = logS0 + (r-0.5*sigma^2)*T + sigma*sqrt(T)*epsilon;
ST = exp( logST );
discountedPayoffs = exp(-r*T)*max(ST-K,0);
price = mean(discountedPayoffs);
errorEstimate = std(discountedPayoffs)/sqrt(nPaths);

end    


