% Price a call option by importance sampling
% (Obviously this is somewhat unrealistic since we can already
% price call options anlaytically, but importance sampling can
% be applied to more interesting options)
function [price,error] = callImportance( K,T, ...
                         S0,r,sigma, ...
                         nPaths )

logS0 = log(S0);
% Generate random numbers u on the interval [lowestU,1]
lowestU = normcdf( (log(K)-logS0 - (r-0.5*sigma^2)*T)/(sigma*sqrt(T)) );
u = rand(nPaths,1)*(1-lowestU)+lowestU;

% Now generate stock paths using norminv( u ). lowestU was chosen
% so that the lowest possible stock price obtained is K. Note that
% we are only considering a certain proportion of possible stock prices
logST = logS0 + (r-0.5*sigma^2)*T + sigma*sqrt(T)*norminv(u);
ST = exp( logST );
discountedPayoff = exp(-r*T)*(ST-K);

% Since we only simulate a certain proportion of prices, the true
% epectation of the final option value must be weighted by proportion
proportion = 1-lowestU;
price = mean(discountedPayoff)*proportion;
error = std(discountedPayoff)*proportion/sqrt(nPaths);                       

end    
