function [price,errorEstimate, c] = callControlVariate( K,T, ...
                         S0,r,sigma, ...
                         nPaths, ...
                         c)

% Usual pricing code
logS0 = log(S0);
epsilon = randn( nPaths,1 );
logST = logS0 + (r-0.5*sigma^2)*T + sigma*sqrt(T)*epsilon;
ST = exp( logST );
discountedPayoffs = exp(-r*T)*max(ST-K,0);

% Standard formula for control variate method
m = discountedPayoffs;
t = exp(-r*T)*ST;
tau = S0;
covMatrix = cov(m,t);
if nargin<7
    c = -covMatrix(1,2)/covMatrix(2,2);
end    
mStar = m + c*(t-tau);

% Result
price = mean(mStar);
errorEstimate = std(mStar)/sqrt(nPaths);

end  

