% Price a call option by antithetic sampling
function [price,errorEstimate] = callAntithetic( K,T, ...
                                 S0,r,sigma, ...
                                 nPaths )

logS0 = log(S0);
epsilon1 = randn( nPaths/2,1 );
epsilon2 = -epsilon1;
logST1 = logS0 + (r-0.5*sigma^2)*T + sigma*sqrt(T)*epsilon1;
logST2 = logS0 + (r-0.5*sigma^2)*T + sigma*sqrt(T)*epsilon2;
ST1 = exp( logST1 );
ST2 = exp( logST2 );
discountedPayoffs1 = exp(-r*T)*max(ST1-K,0);
discountedPayoffs2 = exp(-r*T)*max(ST2-K,0);
price = mean(0.5*(discountedPayoffs1+discountedPayoffs2));
errorEstimate = std(0.5*(discountedPayoffs1+discountedPayoffs2))/sqrt(nPaths/2);
end    
