import math


def solve_quadratic(a,b,c):
    discriminant = b**2-4*a*c
    x1 = (-b + math.sqrt(discriminant))/(2*a)
    x2 = (-b - math.sqrt(discriminant))/(2*a)
    return x1,x2


def victor(x,y):
    """Return the index of the victor, or None"""
    if x=='paper':
        if y=='paper':
            return None
        elif y=='scissors':
            return 1
        elif y=='stone':
            return 0
        else:
            raise Exception('Invalid value '+str(y))
    elif x=='scissors':
        if y == 'paper':
            return 0
        elif y == 'scissors':
            return None
        elif y == 'stone':
            return 1
        else:
            raise Exception('Invalid value ' + str(y))
    elif x == 'stone':
        if y == 'paper':
            return 1
        elif y == 'scissors':
            return 0
        elif y == 'stone':
            return None
        else:
            raise Exception('Invalid value ' + str(y))
    else:
        raise Exception('Invalid value ' + str(y))


def is_fibonacci( x ):
    n=1
    fib = 0
    while fib<x:
        fib = fibonacci(n)
        if fib==x:
            return True
        n += 1
    return False


def fibonacci( n ):
    a = 1
    b = 1
    for i in range(1,n):
        a,b=b,a+b
    return a


def euclidean_algorithm( a, b):
    if abs(a)>abs(b):
        g, y, x = euclidean_algorithm(b,a)
        return g,x,y
    r = b % a
    if r==0:
        return a, 1, 0
    q = (b-r)//a
    g, x1, y1 = euclidean_algorithm(r,a)
    return g, y1 - x1*q, x1


def gcd(a,b):
    triple = euclidean_algorithm(a,b)
    return triple[0]


def generate_fibonacci():
    a = 1
    b = 1
    while True:
        yield a
        a,b=b,a+b


def is_fibonacci_2( x ):
    for fib in generate_fibonacci():
        if fib==x:
            return True
        if fib>x:
            return False


def is_prime_1(n):
    for x in range(2, n):
        if n % x == 0:
            return False
    return True


def is_prime_2(n):
    x = 2
    while True:
        if x>=n:
            return True
        if n % x == 0:
            break
        x+=1
    return False


def is_prime_3(n):
    for x in range(2, n):
        if n % x == 0:
            break
    else:
        return True
    return False


def find_factors(n):
    factors = []
    for x in range(1, n+1):
        if not( n % x == 0):
            continue
        factors.append(x)
    return factors


def print_number( number, base=10, units='', currency=''):
    assert (base<=10)
    print(currency, end='')
    digits = []
    if number==0:
        digits.append('0')
    while number>0:
        digit = number % base
        digits.append(str(digit))
        number = number//base
    for digit in reversed(digits):
        print(digit, end='')
    print(units, end='')
    print() # inserts newline

def sieve_of_eratosthenes(n):
    return set(  x for x in range(2,n+1) if x not in { a*b for a in range(2,n) for b in range(2,n//a + 1)})


fibonacciCache = {}
'''User to store a cache of fibonacci numbers'''


def fibonacci_by_recursion( n ) :
    if n<=2:
        return 1
    if n in fibonacciCache:
        return fibonacciCache[n]
    ret = fibonacci_by_recursion(n-2)+fibonacci_by_recursion(n-1)
    fibonacciCache[n] = ret;
    return ret


def concatenate( *iterables ):
    for iterable in iterables:
        i = iter(iterable)
        try:
            while True:
                yield next(i)
        except StopIteration:
            pass
    raise StopIteration


def max_iterable( iterable ):
    i = iter(iterable)
    try:
        max_val = next(i)
        try:
            while True:
                n = next(i)
                if n>max_val:
                    max_val = n
        except StopIteration:
            return max_val
    except StopIteration:
        raise ValueError('No maximum')


def integrate_midpoint( f, start=0, end=1, n=1000):
    h = (end-start)/n
    s = 0
    for i in range(0,n):
        x = start + (i+1)*h
        s+=f(x)*h
    return s


def merge(c1, c2):
    """Takes two iterables that are assumed to be in order and merges them together"""
    # What a nightmare this proves to be! Good luck with getting this kind of thing
    # working without tests
    i1 = iter(c1)
    i2 = iter(c2)
    val1_set = False
    val2_set = False
    val1 = None
    val2 = None
    while True:
        if not val1_set:
            try:
                val1 = next(i1)
                val1_set = True
            except StopIteration:
                pass
        if not val2_set:
            try:
                val2 = next(i2)
                val2_set = True
            except StopIteration:
                pass
        if val1_set:
            if val2_set:
                if val1<val2:
                    val1_set = False
                    yield val1
                else:
                    val2_set = False
                    yield val2
            else:
                val1_set = False
                yield val1
        elif val2_set:
            val2_set = False
            yield val2
        else:
            raise StopIteration()


def sort_merge( l ):
    if len(l)<=1:
        return l
    all_items = list(l)
    even_items = [ all_items[x] for x in range(0,len(all_items)) if x%2==0]
    odd_items = [all_items[x] for x in range(0, len(all_items)) if x%2!= 0]
    return merge(sort_merge(even_items), sort_merge(odd_items))
