from graphics import *
import nose.tools
import numpy.linalg as LA


def assert_equals_numpy( v1, v2, tol=0.001 ):
    v1 = numpy.array(v1)
    v2 = numpy.array(v2)
    assert (LA.norm(v1 - v2)<tol), "Expected {} but was {}".format(v2,v1)


def test_viewpoint():
    v = Viewpoint()
    projected, distance = v._project(numpy.array([1, 2, 3]))
    assert_equals_numpy( projected, [1,3] )
    nose.tools.assert_almost_equal(distance, -2)

    projected, distance = v._project(v.eye)
    assert_equals_numpy( projected, [0,0])
    nose.tools.assert_almost_equal(distance, 1)

    c2d = v.coords_2d( numpy.array([1,3,2]))
    assert_equals_numpy( c2d,[0.25,0.5] )

    # Points on the picture plane mapped to themselves
    c2d = v.coords_2d(numpy.array([1, 0, 0]))
    assert_equals_numpy(c2d, [1.0, 0.0])

    c2d = v.coords_2d(numpy.array([0, 0, 0]))
    assert_equals_numpy(c2d, [0.0, 0.0])

    c2d = v.coords_2d(numpy.array([0, 0, 1]))
    assert_equals_numpy(c2d, [0.0, 1.0])

    c2d = v.coords_2d(numpy.array([1, 0, 1]))
    assert_equals_numpy(c2d, [1.0, 1.0])

    # More interesting mappings for points off the picture plane
    c2d = v.coords_2d(numpy.array([1, 1, 0]))
    assert_equals_numpy(c2d, [0.5, 0.0])

    c2d = v.coords_2d(numpy.array([0, 1, 0]))
    assert_equals_numpy(c2d, [0.0, 0.0])

    c2d = v.coords_2d(numpy.array([0, 1, 1]))
    assert_equals_numpy(c2d, [0.0, 0.5])

    c2d = v.coords_2d(numpy.array([1, 1, 1]))
    assert_equals_numpy(c2d, [0.5, 0.5])

    # Raising the eye lifts points at the back
    v.eye = numpy.array([0,-1,1])
    c2d = v.coords_2d(numpy.array([1, 1, 1]))
    assert_equals_numpy(c2d, [0.5, 1.0])


def test_cube():
    c = Cube()
    assert( len(c._edges())==12 )

    g = Graphics2D()
    v = Viewpoint()
    cube = Cube()
    cube.draw(v, g)
    print(g)


def test_isometry():
    rx = Isometry.rotation(math.pi/2, 0, 0)
    assert_equals_numpy(rx.transform_point(numpy.array([0,1,0])), [0,0,-1])


def test_line3d():
    g = Graphics2D();
    v = Viewpoint();
    l3 = Line3D();
    l3.draw(v,g);
    nose.tools.assert_equals(str(g),"A Graphics2D. Contents are: A line from [ 0.  0.] to [ 1.  0.]")


