from diffiehelman import *


def test_multiplicative_group():
    p = 17
    a = 14
    b = 6

    aG = ModInteger(p,a)
    bG = ModInteger(p,b)

    assert (aG * bG).value == (a * b) % p

    div = aG/bG
    assert div*bG == aG

    div = bG/aG
    assert div * aG == bG


def test_exponentiate():
    p = 17
    a = 14
    n = 1

    aG = ModInteger(p,a)
    res = exponentiate(aG, n).value

    assert res == (a ** n) % p


def test_diffiehelman():
    p = 982451653
    base = ModInteger(p,126363)

    alice = DiffieHelmanExchanger( base )
    bob = DiffieHelmanExchanger( base )
    shared_secret1 = alice.shared_secret( bob.public )
    shared_secret2 = bob.shared_secret( alice.public )

    assert shared_secret1==shared_secret2


def test_elliptic_curve():
    ec = EllipticCurve(3,5,7)
    p1 = EllipticCurvePoint(ec,1,3)
    p2 = EllipticCurvePoint(ec, 1, 4)
    p3 = p1 * p2  #
    assert p3 == p2 * p1


def test_elliptic_curve_diffie_hellman():
    ec = EllipticCurve(3,5,7)
    base = EllipticCurvePoint(ec,1,3)

    alice = DiffieHelmanExchanger(base)
    bob = DiffieHelmanExchanger(base)
    shared_secret1 = alice.shared_secret(bob.public)
    shared_secret2 = bob.shared_secret(alice.public)

    assert shared_secret1==shared_secret2
    print( str(shared_secret1 ))
