import mymath
import nose.tools
import math
import random
import time


def test_solve_quadratic():
    a = 2; b = 3; c = -7
    x1,x2 = mymath.solve_quadratic(a,b,c)
    for x in x1,x2:
        nose.tools.assert_almost_equals(a * x * x + b * x + c, 0.0)

def test_victor():
    assert( mymath.victor('paper','scissors')==1)

def test_fibonacci():
    actual = []
    for i in range(1,7):
        actual.append( mymath.fibonacci(i))
    nose.tools.assert_equals( actual, [1, 1, 2, 3, 5, 8])


def test_is_fibonacci():
    assert mymath.is_fibonacci(8)
    assert not mymath.is_fibonacci(9)


def test_gcd():
    nose.tools.assert_equal(abs(mymath.gcd(2,6)), 2);
    nose.tools.assert_equal(abs(mymath.gcd(6,2)),2)
    nose.tools.assert_equal(abs(mymath.gcd(2,-6)),2)
    nose.tools.assert_equal(abs(mymath.gcd(1183, 364)),91)


def test_euclidean_algortihm():
    a = 1183
    b = 364
    (g,x,y) = mymath.euclidean_algorithm(a, b)
    nose.tools.assert_equal(a*x + b*y, g)


def test_is_fibonacci_2():
    assert mymath.is_fibonacci_2(8)
    assert not mymath.is_fibonacci_2(9)


def test_generate_fibonacci():
    all_fib = iter(mymath.generate_fibonacci())
    first_six = []
    for i in range(0,6):
        first_six.append( next(all_fib))
    nose.tools.assert_equals(first_six, [1, 1, 2, 3, 5, 8])


def test_is_prime():
    assert( mymath.is_prime_1(7))
    assert( not mymath.is_prime_1(35))
    assert (mymath.is_prime_2(7))
    assert (not mymath.is_prime_2(35))
    assert (mymath.is_prime_3(7))
    assert (not mymath.is_prime_3(35))


def test_find_factors():
    actual = mymath.find_factors(35)
    nose.tools.assert_equals( actual, [1, 5, 7, 35])


def test_sieve_of_eratosthenes():
    values = mymath.sieve_of_eratosthenes(100)
    for i in values:
        assert mymath.is_prime_1(i)
    for i in range(2,101):
        if i not in values:
            assert not mymath.is_prime_1(i)


def test_fibonacci_by_recursion():
    for i in range(10,1,-1):
        assert mymath.fibonacci(i)==mymath.fibonacci_by_recursion(i)


def test_concatenate():
    actual = list(mymath.concatenate([1,2,3],[4,5,6],[7,8,9]))
    nose.tools.assert_equals(actual,[1,2,3,4,5,6,7,8,9])


def test_max_iterable():
    m = mymath.max_iterable([-4,-1,-8])
    nose.tools.assert_equals(m,-1)
    try:
        mymath.max_iterable([])
        raise Exception('Should be impossible')
    except ValueError:
        pass


def test_integrate_midpoint():
    val = mymath.integrate_midpoint( lambda x: math.sin(x), start=0, end=2, n=10000)
    nose.tools.assert_almost_equal( val, -math.cos(2.0)+math.cos(0.0),3)


def test_marge():
    actual = list(mymath.merge([2, 4, 9],[0,1,5,11,13]))
    nose.tools.assert_equals(actual,[0,1,2,4,5,9,11,13])


def test_sort_merge():
    actual = list(mymath.sort_merge([9, 2, 1, 13, 3, 8, 8, 2, 0]))
    nose.tools.assert_equals(actual, [0, 1, 2, 2, 3, 8, 8, 9, 13])

    # test with a large list
    for e in range(1,10):
        n = 2**e
        l = []
        for i in range(0,n):
            l.append( random.randint(0,1000000) )
        for sort_function in [mymath.sort_merge, sorted]:
            print('Using sort function ' + str(sort_function))
            start = time.clock()
            s = list(sort_function(l))
            end = time.clock()
            print("Time elapsed {}s".format((end-start)))
            for i in range(0,n-1):
                assert s[i]<=s[i+1]
            print("n = {}".format(n))
            ratio = (end - start) / (n * math.log(n));
            print("Time elapsed/Time predicted {}".format(ratio))
