import mymath
import nose.tools

def test_solve_quadratic():
    a = 2; b = 3; c = -7
    x1,x2 = mymath.solve_quadratic(a,b,c)
    for x in x1,x2:
        nose.tools.assert_almost_equals(a * x * x + b * x + c, 0.0)


def test_victor():
    assert( mymath.victor('paper','scissors')==1)


def test_fibonacci():
    actual = []
    for i in range(1,7):
        actual.append( mymath.fibonacci(i))
    nose.tools.assert_equals( actual, [1, 1, 2, 3, 5, 8])


def test_is_fibonacci():
    assert mymath.is_fibonacci(8)
    assert not mymath.is_fibonacci(9)


def test_gcd():
    nose.tools.assert_equal(abs(mymath.gcd(2,6)), 2);
    nose.tools.assert_equal(abs(mymath.gcd(6,2)),2)
    nose.tools.assert_equal(abs(mymath.gcd(2,-6)),2)
    nose.tools.assert_equal(abs(mymath.gcd(1183, 364)),91)


def test_euclidean_algortihm():
    a = 1183
    b = 364
    (g,x,y) = mymath.euclidean_algorithm(a, b)
    nose.tools.assert_equal(a*x + b*y, g)

