import math


def solve_quadratic(a,b,c):
    discriminant = b**2-4*a*c
    x1 = (-b + math.sqrt(discriminant))/(2*a)
    x2 = (-b - math.sqrt(discriminant))/(2*a)
    return x1,x2


def victor(x,y):
    """Return the index of the victor, or None"""
    if x=='paper':
        if y=='paper':
            return None
        elif y=='scissors':
            return 1
        elif y=='stone':
            return 0
        else:
            raise Exception('Invalid value '+str(y))
    elif x=='scissors':
        if y == 'paper':
            return 0
        elif y == 'scissors':
            return None
        elif y == 'stone':
            return 1
        else:
            raise Exception('Invalid value ' + str(y))
    elif x == 'stone':
        if y == 'paper':
            return 1
        elif y == 'scissors':
            return 0
        elif y == 'stone':
            return None
        else:
            raise Exception('Invalid value ' + str(y))
    else:
        raise Exception('Invalid value ' + str(y))


def is_fibonacci( x ):
    n=1
    fib = 0
    while fib<x:
        fib = fibonacci(n)
        if fib==x:
            return True
        n += 1
    return False


def fibonacci( n ):
    a = 1
    b = 1
    for i in range(1,n):
        a,b=b,a+b
    return a


def euclidean_algorithm( a, b):
    if abs(a)>abs(b):
        g, y, x = euclidean_algorithm(b,a)
        return g,x,y
    r = b % a
    if r==0:
        return a, 1, 0
    q = (b-r)//a
    g, x1, y1 = euclidean_algorithm(r,a)
    return g, y1 - x1*q, x1


def gcd(a,b):
    triple = euclidean_algorithm(a,b)
    return triple[0]

